;________________________________________________________________________
;
;                            P A C K E T . A S M  
;________________________________________________________________________
;
; Packet sending routines by Byon Garrabrant  N6BG  byon@mail.com  Feb 99
;________________________________________________________________________
;
;   This software is  available only for non-commercial  amateur radio 
;   or educational  applications.   ALL  other  uses  are  prohibited.  
;   This  software may  be  modified  only  if the  resulting code  be 
;   made available  publicly  and the  original  author given  credit.  
;   Contact the author or TAPR for information on commercial licenses. 
;   (c) Copyright 1999,  Byon Garrabrant,  N6BG.  All rights reserved. 
;________________________________________________________________________

	cblock				; packet variables
		packet_sending_char
		packet_sending_count
		packet_bit_history
		packet_crc_hi
		packet_crc_lo
		packet_temp
	endc
;________________________________________________________________________

#define	PTT_OUT			PORTA, 2
#define	MODE1_OUT		PORTB, 1
#define	MODE0_OUT		PORTB, 2
#define	TONE_OUT		PORTB, 5
#define	TX_DELAY		D'40'
#define	BANK1			H'7F'
;________________________________________________________________________

; Note add H'61' to the last callsign SSID, add H'60' to all other SSIDs

Get_Header
	addwf	PCL, F
	; dest callsign
	dt	'C'<<1,'Q'<<1,' '<<1,' '<<1,' '<<1,' '<<1, (D'0'<<1)|H'60'	
	; source callsign
	dt	'N'<<1,'6'<<1,'B'<<1,'G'<<1,' '<<1,' '<<1, (D'0'<<1)|H'61'	
	; digi callsign (optional)
;	dt	'R'<<1,'E'<<1,'L'<<1,'A'<<1,'Y'<<1,' '<<1, (D'0'<<1)|H'61'	
	dt	H'03', H'F0'
	dt	0
;________________________________________________________________________

Packet_Init
	bsf	STATUS, RP0		; Select Bank 1
	bcf	TONE_OUT		; make data an output
	bcf	MODE0_OUT		; make mode0 an output
	bcf	MODE1_OUT		; make mode1 an output
	bcf	PTT_OUT			; make PTT an output
	movlw	b'11010011'		; div timer by 16
	movwf	OPTION_REG & BANK1	; and enable TMR0
	bcf	STATUS, RP0		; Select Bank 0
	bcf	PTT_OUT			; release PTT
	goto	Tone_Disable		; disable tone
;________________________________________________________________________

Packet_Send_Bit
	rlf	packet_bit_history, F	; store the last 8 bits sent
	movlw	D'130'			; bump TMR0 forward forward
	subwf	TMR0, F			; 1200 baud updates
	rrf	packet_bit_history, W	; restore the bit
	
	btfss	INTCON, T0IF		; wait for last bit to be sent
	 goto	$-1
	bcf	INTCON, T0IF		; clear TMR0 overflow

	movlw	B'00100000' 		
	skpc				; if sending a 0
	 xorwf	PORTB, F		; toggle TONE_OUT

	comf	packet_bit_history, W	; check the last 5 bits
	andlw	H'1F'			; for bit stuffing
 	skpz				; if not all 1s
 	 return				; return
	clrc				; send a transparent 0 bit
	goto	Packet_Send_Bit			
;________________________________________________________________________

Packet_Flag				
	movlw	H'7E'			; send a flag 0x7E
	movwf	packet_sending_char
	movlw	8			; send 8 bits
	movwf	packet_sending_count
Packet_Flag_Loop
	rrf	packet_sending_char, F	; get bit for sending
 	call	Packet_Send_Bit		; send it
	clrf	packet_bit_history	; no bit stuffing for flags
	decfsz	packet_sending_count, F	; send all 8 bits
	 goto	Packet_Flag_Loop
	return 				; done
;________________________________________________________________________

Packet_Start
	bsf	PTT_OUT			; press PTT
	bcf	MODE1_OUT		; enable audio tone
	bsf	MODE0_OUT		; enable audio tone

	movlw	TX_DELAY		; get initial flag count
	movwf	packet_temp
Packet_Start_Flag_Loop
	call	Packet_Flag		; send the initial flags
	decfsz	packet_temp, F
	 goto	Packet_Start_Flag_Loop

	movlw	H'FF'			; crc inits to 0xFFFF
	movwf	packet_crc_hi
	movwf	packet_crc_lo

Packet_Send_Header			; send the header
	movfw	packet_temp
	call	Get_Header
	iorlw	0			; until we get a 0
	skpnz				; then return
	 return
	call	Packet_Send		; send each byte
	incf	packet_temp, F
	goto	Packet_Send_Header	; and loop back
;________________________________________________________________________

Packet_Send
	movwf	packet_sending_char	; save the cahr to send
	movlw	8			; send 8 bits
	movwf	packet_sending_count
Packet_Send_Loop
	rrf	packet_sending_char, W	; save bit for CRC
	movlw	1
	skpnc
	 xorwf	packet_crc_lo, F	; crc ^= d & 1;
	clrc
	rrf	packet_crc_hi, F	; crc >>= 1
	rrf	packet_crc_lo, F
	skpc
	 goto	Packet_CRC_Done		; if shifted off 1
	movlw	H'08'			; xor POLY 0x8408
	xorwf	packet_crc_lo, F
	movlw	H'84'
	xorwf	packet_crc_hi, F	
Packet_CRC_Done
	rrf	packet_sending_char, F	; get bit again for sending
 	call	Packet_Send_Bit		; send it
	decfsz	packet_sending_count, F	; continue for all 8 bits
	 goto	Packet_Send_Loop
	return 				; done
;________________________________________________________________________

Packet_End
	movlw	H'FF'			; invert CRC
	xorwf	packet_crc_lo, F	
	xorwf	packet_crc_hi, W	
	movwf	packet_temp		; save hi in temp
	movfw	packet_crc_lo		; send lo
	call	Packet_Send
	movfw	packet_temp		; send hi
	call	Packet_Send
	call	Packet_Flag		; send final flags
	call	Packet_Flag		; send final flags
	call	Packet_Flag		; send final flags
	call	Packet_Flag		; send final flags
Tone_Disable
	bsf	MODE1_OUT		; disable audio tone
	bcf	MODE0_OUT		; disable audio tone
	bcf	TONE_OUT		; disable audio tone
	bcf	PTT_OUT			; release PTT
	return
;________________________________________________________________________

